/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class LOTRItemOwnership {
    public static void setCurrentOwner(ItemStack itemstack, String name) {
        String previousCurrentOwner;
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if ((previousCurrentOwner = LOTRItemOwnership.getCurrentOwner(itemstack)) != null) {
            LOTRItemOwnership.addPreviousOwner(itemstack, previousCurrentOwner);
        }
        NBTTagCompound nbt = itemstack.func_77978_p();
        nbt.func_74778_a("LOTRCurrentOwner", name);
    }

    public static String getCurrentOwner(ItemStack itemstack) {
        NBTTagCompound nbt;
        if (itemstack.func_77978_p() != null && (nbt = itemstack.func_77978_p()).func_150297_b("LOTRCurrentOwner", 8)) {
            return nbt.func_74779_i("LOTRCurrentOwner");
        }
        return null;
    }

    public static void addPreviousOwner(ItemStack itemstack, String name) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        List<String> previousOwners = LOTRItemOwnership.getPreviousOwners(itemstack);
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt.func_150297_b("LOTROwner", 8)) {
            nbt.func_82580_o("LOTROwner");
        }
        List<String> lastPreviousOwners = previousOwners;
        previousOwners = new ArrayList<String>();
        previousOwners.add(name);
        previousOwners.addAll(lastPreviousOwners);
        while (previousOwners.size() > 3) {
            previousOwners.remove(previousOwners.size() - 1);
        }
        NBTTagList tagList = new NBTTagList();
        for (String owner : previousOwners) {
            tagList.func_74742_a((NBTBase)new NBTTagString(owner));
        }
        nbt.func_74782_a("LOTRPrevOwnerList", (NBTBase)tagList);
    }

    public static List<String> getPreviousOwners(ItemStack itemstack) {
        ArrayList<String> owners = new ArrayList<String>();
        if (itemstack.func_77978_p() != null) {
            NBTTagCompound nbt = itemstack.func_77978_p();
            if (nbt.func_150297_b("LOTROwner", 8)) {
                String outdatedOwner = nbt.func_74779_i("LOTROwner");
                owners.add(outdatedOwner);
            }
            if (nbt.func_150297_b("LOTRPrevOwnerList", 9)) {
                NBTTagList tagList = nbt.func_150295_c("LOTRPrevOwnerList", 8);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    String owner = tagList.func_150307_f(i);
                    owners.add(owner);
                }
            }
        }
        return owners;
    }
}

